#!/bin/bash
#
# sample shell script for Oracle Enterprise Manager 11g
#
# This sample script should work on Linux system where default locale is set to UTF-8.

# The command to cooperate with Systemwalker is executed.
function main {
mpadevtalert -s "$SYSTEMWALKER_SEVERITY" -n "$SYSTEMWALKER_HOST" -m "$SYSTEMWALKER_MESSAGE"

return 0
}

# The PATH environment variable is set.

export PATH=/opt/systemwalker/bin:$PATH
export PATH=/opt/FJSVmoms/OEM/bin:$PATH

# Alert information is set to the environment variable.

export EM_SEVERITY=$SEVERITY
export EM_HOST=$HOST
export EM_MESSAGE=$MESSAGE
export EM_TARGET_TYPE=$TARGET_TYPE

# Environment variable for test of OEM notification method

if [ -z "$SEVERITY" ]; then
 export EM_SEVERITY="警告"
fi

if [ -z "$HOST" ]; then
 export EM_HOST="SERVER_NAME"
fi

if [ -z "$TARGET_TYPE" ]; then
 export EM_TARGET_TYPE="TARGET_TYPE"
fi

# The argument for Sysytemwalker is set.

export SYSTEMWALKER_HOST=$EM_HOST
export SYSTEMWALKER_MESSAGE=OEM_"$EM_TARGET_TYPE"_"$EM_MESSAGE"

# Severity information is converted for Systemwalker.

if [ "$EM_SEVERITY" = "警告" ]; then
 export SYSTEMWALKER_SEVERITY=Warning
 main
fi

if [ "$EM_SEVERITY" = "クリティカル" ]; then
 export SYSTEMWALKER_SEVERITY=Error
 main
fi

if [ "$EM_SEVERITY" = "クリア" ]; then
 export SYSTEMWALKER_SEVERITY=Information
 main
fi

if [ "$EM_SEVERITY" = "メトリックエラーの開始" ]; then
 export SYSTEMWALKER_SEVERITY=Error
 main
fi

if [ "$EM_SEVERITY" = "メトリックエラーのクリア" ]; then
 export SYSTEMWALKER_SEVERITY=Information
 main
fi

if [ "$EM_SEVERITY" = "" ]; then
 export SYSTEMWALKER_SEVERITY=Information
 main
fi
