#!/bin/bash
#
# sample.sh for Oracle Enterprise Manager 12c
#
# This sample script should work on Linux system where default locale is set to UTF-8.

#連携コマンドの実行
function main {
mpadevtalert -s "$SYSTEMWALKER_SEVERITY" -n "$SYSTEMWALKER_HOST" -m "$SYSTEMWALKER_MESSAGE"

return 0
}

#PATH環境変数の設定

export PATH=/opt/systemwalker/bin:$PATH
export PATH=/opt/FJSVmoms/OEM/bin:$PATH

#アラート情報の受け渡し

export EM_SEVERITY=$SEVERITY_CODE
export EM_HOST=$HOST_NAME
export EM_MESSAGE=$MESSAGE
export EM_TARGET_TYPE=$TARGET_TYPE

#EMでの通知メソッドのテスト時に使用するテスト用環境変数

if [ -z "$SEVERITY_CODE" ]; then
 export EM_SEVERITY="WARNING"
fi

if [ -z "$HOST_NAME" ]; then
 export EM_HOST="サーバー名"
fi

if [ -z "$TARGET_TYPE" ]; then
 export EM_TARGET_TYPE="ターゲットタイプ"
fi

#連携コマンドに渡す引数の作成

export SYSTEMWALKER_HOST=$EM_HOST
export SYSTEMWALKER_MESSAGE=OEM_"$EM_TARGET_TYPE"_"$EM_MESSAGE"

#重大度情報の変換と連携コマンドの呼び出し

if [ "$EM_SEVERITY" = "FATAL" ]; then
 export SYSTEMWALKER_SEVERITY=Error
elif [ "$EM_SEVERITY" = "CRITICAL" ]; then
 export SYSTEMWALKER_SEVERITY=Error
elif [ "$EM_SEVERITY" = "WARNING" ]; then
 export SYSTEMWALKER_SEVERITY=Warning
elif [ "$EM_SEVERITY" = "MINOR_WARNING" ]; then
 export SYSTEMWALKER_SEVERITY=Warning
elif [ "$EM_SEVERITY" = "INFORMATIONAL" ]; then
 export SYSTEMWALKER_SEVERITY=Information
elif [ "$EM_SEVERITY" = "CLEAR" ]; then
 export SYSTEMWALKER_SEVERITY=Information
else
 export SYSTEMWALKER_SEVERITY=Information
fi

main
