#!/bin/bash
#
# sample shell script for Oracle Enterprise Manager 12c
#
#

# The command to cooperate with Systemwalker is executed.
function main {
mpadevtalert -s "$SYSTEMWALKER_SEVERITY" -n "$SYSTEMWALKER_HOST" -m "$SYSTEMWALKER_MESSAGE"

return 0
}

# The PATH environment variable is set.

export PATH=/opt/systemwalker/bin:$PATH
export PATH=/opt/FJSVmoms/OEM/bin:$PATH

# Alert information is set to the environment variable.

export EM_SEVERITY=$SEVERITY_CODE
export EM_HOST=$HOST_NAME
export EM_MESSAGE=$MESSAGE
export EM_TARGET_TYPE=$TARGET_TYPE

# Environment variable for test of OEM notification method

if [ -z "$SEVERITY_CODE" ]; then
 export EM_SEVERITY="WARNING"
fi

if [ -z "$HOST_NAME" ]; then
 export EM_HOST="SERVER_NAME"
fi

if [ -z "$TARGET_TYPE" ]; then
 export EM_TARGET_TYPE="TARGET_TYPE"
fi

# The argument for Sysytemwalker is set.

export SYSTEMWALKER_HOST=$EM_HOST
export SYSTEMWALKER_MESSAGE=OEM_"$EM_TARGET_TYPE"_"$EM_MESSAGE"

# Severity information is converted for Systemwalker.

if [ "$EM_SEVERITY" = "FATAL" ]; then
 export SYSTEMWALKER_SEVERITY=Error
elif [ "$EM_SEVERITY" = "CRITICAL" ]; then
 export SYSTEMWALKER_SEVERITY=Error
elif [ "$EM_SEVERITY" = "WARNING" ]; then
 export SYSTEMWALKER_SEVERITY=Warning
elif [ "$EM_SEVERITY" = "MINOR_WARNING" ]; then
 export SYSTEMWALKER_SEVERITY=Warning
elif [ "$EM_SEVERITY" = "INFORMATIONAL" ]; then
 export SYSTEMWALKER_SEVERITY=Information
elif [ "$EM_SEVERITY" = "CLEAR" ]; then
 export SYSTEMWALKER_SEVERITY=Information
else
 export SYSTEMWALKER_SEVERITY=Information
fi

main
