#!/bin/bash
#
# sample.sh
# This sample script should work on Linux system where default locale is set to UTF-8.

#連携コマンドの実行
function main {
mpadevtalert -s "$SYSTEMWALKER_SEVERITY" -n "$SYSTEMWALKER_HOST" -m "$SYSTEMWALKER_MESSAGE"

return 0
}

#PATH環境変数の設定

export PATH=/opt/systemwalker/bin:$PATH
export PATH=/opt/FJSVmoms/OEM/bin:$PATH

#アラート情報の受け渡し

export EM_SEVERITY=$SEVERITY
export EM_HOST=$HOST
export EM_MESSAGE=$MESSAGE
export EM_TARGET_TYPE=$TARGET_TYPE

#EMでの通知メソッドのテスト時に使用するテスト用環境変数

if [ -z "$SEVERITY" ]; then
 export EM_SEVERITY="警告"
fi

if [ -z "$HOST" ]; then
 export EM_HOST="サーバー名"
fi

if [ -z "$TARGET_TYPE" ]; then
 export EM_TARGET_TYPE="ターゲットタイプ"
fi

#連携コマンドに渡す引数の作成

export SYSTEMWALKER_HOST=$EM_HOST
export SYSTEMWALKER_MESSAGE=OEM_"$EM_TARGET_TYPE"_"$EM_MESSAGE"

#重大度情報の変換と連携コマンドの呼び出し

if [ "$EM_SEVERITY" = "警告" ]; then
 export SYSTEMWALKER_SEVERITY=Warning
 main
fi

if [ "$EM_SEVERITY" = "クリティカル" ]; then
 export SYSTEMWALKER_SEVERITY=Error
 main
fi

if [ "$EM_SEVERITY" = "クリア" ]; then
 export SYSTEMWALKER_SEVERITY=Information
 main
fi

if [ "$EM_SEVERITY" = "メトリックエラーの開始" ]; then
 export SYSTEMWALKER_SEVERITY=Error
 main
fi

if [ "$EM_SEVERITY" = "メトリックエラーのクリア" ]; then
 export SYSTEMWALKER_SEVERITY=Information
 main
fi

if [ "$EM_SEVERITY" = "" ]; then
 export SYSTEMWALKER_SEVERITY=Information
 main
fi
