#!/bin/bash

# JP1のイベント登録コマンド
main()
{ jevsend -i 999 -m "$JP1_MESSAGE" -e SEVERITY="$JP1_SEVERITY" -e HOST="$JP1_HOST" -e PRODUCT_NAME="/ORACLE/EM/EVENT"
  exit 0
}

# PATH環境変数のセット
export PATH=/opt/jp1base/bin:$PATH

export LANG=ja_JP.UTF-8


# アラート情報の受け渡し
# $SEVERITY, $HOST, $MESSAGE, $TARGET_TYPEはいずれも
# アラート内容に応じて自動的にセットされる
export EM_SEVERITY=$SEVERITY
export EM_HOST=$HOST
# アラートメッセージに含まれる"を'に置換
export EM_MESSAGE=`echo $MESSAGE |sed -e "s/\"/\'/g"`
export EM_TARGET_TYPE=$TARGET_TYPE

# 通知テスト時に使用するダミーのアラート情報
if  [ -z $SEVERITY ]
then
 export EM_SEVERITY=警告
fi
if  [ -z $HOST ]
then
 export EM_HOST=サーバー名
fi
if  [ -z $TARGET_TYPE ]
then
 export EM_TARGET_TYPE=ターゲットタイプ
fi

# JP1のイベント登録コマンドに渡す引数の作成
export JP1_HOST=$EM_HOST
export JP1_MESSAGE=OEM_"$EM_HOST"_"$EM_TARGET_TYPE"_"$EM_MESSAGE"

# 重大度情報の変換

if [ $EM_SEVERITY = "警告" ]
then
        export JP1_SEVERITY=Warning
elif [ $EM_SEVERITY = "クリティカル" ]
then
        export JP1_SEVERITY=Critical
elif [ $EM_SEVERITY = "クリア" ]
then
        export JP1_SEVERITY=Information
elif [ $EM_SEVERITY = "メトリックエラーの開始" ]
then
        export JP1_SEVERITY=Error
elif [ $EM_SEVERITY = "メトリックエラーのクリア" ]
then
        export JP1_SEVERITY=Information
else
        export JP1_SEVERITY=Information
fi

main